﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Collections.Generic;
using GE.World.Entities;
using Microsoft.Xna.Framework;

namespace GE.Manager
{
    class EnemyManager
    {
        /// <summary>
        /// Singleton
        /// </summary>
        static EnemyManager _instance = null;

        /// <summary>
        /// List of enemies
        /// </summary>
        List<EnemyEntity> _listOfEnemies;

        /// <summary>
        /// Constructor
        /// </summary>
        private EnemyManager()
        {
            _listOfEnemies = new List<EnemyEntity>();
        }

        /// <summary>
        /// Return the singleton
        /// </summary>
        public static EnemyManager Instance { get { if (_instance == null) _instance = new EnemyManager(); return _instance; } }

        /// <summary>
        /// Add an enemy to the manager
        /// </summary>
        /// <param name="e"></param>
        public void addEnemies(EnemyEntity e)
        {
            _listOfEnemies.Add(e);
        }

        /// <summary>
        /// Clear the manager
        /// </summary>
        public void clear()
        {
            _listOfEnemies.Clear();
        }

        /// <summary>
        /// Set the active state of the enemies
        /// </summary>
        /// <param name="bActive"></param>
        public void deactivate()
        {
            foreach (EnemyEntity e in _listOfEnemies)
            {
                e.deactivate();
            }
        }

    }
}
